 ; Ŀ
 ;   Ati - increment attdef tags, make the prompts match.                  
 ;   Copyright 2002, 2004 by Rocket Software Ltd.                          
 ;   No relation to the number.                                            
 ; 

 ; Ŀ
 ;   Subroutine Incrox - increment an A1/B2/etc. format string.            
 ;   Arguments: Str, a string.                                             
 ;              Leona, increment the Number or Letter part.                
 ;              Direc, increment (T) or decrement ().                      
 ;   Calls Krak and Alph.                                                  
 ;   Returns the incremented version.                                      
 ; 
 (DEFUN INCROX (str leona direc / tlist first second)
 ; Ŀ
 ;   Split the tag into a list of the letter and the number part.          
 ; 
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
 ; Ŀ
 ;   Increment the appropriate substring.                                  
 ; 
  (if (= leona "Number")
      (if direc
          (setq second (1+ second))
          (setq second (1- second)))
      (if direc
          (setq first (alph first))
          (setq first (decr first))))
 (strcat first (itoa second)))
 ; Ŀ
 ;   Subroutine Incrox end.                                                
 ; 

 ; Ŀ
 ;   Subroutine Alph - increment a character string.                       
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPH (cname / pos char base cnamp)
  (setq cname (strcase cname))
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to A and add an A to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "A")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes an A,     
 ;   and it is incremented.                                                
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cname 1 (1- pos))
                               (chr (1+ (ascii (substr cname pos 1))))))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "A")))
           (setq cname (strcat cname base))))
 cname)
 ; Ŀ
 ;   Subroutine Alph end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Decr - decrement a character string.                       
 ;   Takes one argument, a string.  Returns the decremented version.       
 ;   Work backwards from the right side of the string, each character is   
 ;   checked, if it's an A it becomes a Z and the one the the left is      
 ;   decremented, otherwise the increment stops when one character has     
 ;   been decremented.  If the leftmost character is an A and need to      
 ;   decremented it then drop it.                                          
 ;   (decr "A") returns "", (decr "") returns "".                          
 ; 
 (DEFUN DECR (str / pos quit char fore aft)
  (setq str (strcase str))
  (setq pos (strlen str))
  (while (and (null quit) (>= pos 1))
         (setq char (substr str pos 1))
         (if (> pos 1)
             (setq fore (substr str 1 (1- pos)))
             (setq fore ""))
         (setq aft (substr str (1+ pos)))
         (cond ((and (= char "A") (= pos 1))
                (setq str aft))
               ((= char "A")
                (setq str (strcat fore "Z" aft)))
               (T
                (setq str (strcat fore (chr (1- (ascii char))) aft))
                (setq quit t)))
         (setq pos (1- pos)))
 str)
 ; Ŀ
 ;   Subroutine Decr end.                                                  
 ; 

 ; Ŀ
 ;   Krak - divide a string into letters and numbers.                      
 ;   Takes one argument, a string, returns a list of two strings.          
 ; 
 (DEFUN KRAK (str / pos p1 p2)
  (setq pos 1)
  (while (and (>= (strlen str) pos)
              (= (type (read (substr str pos 1))) 'SYM))
         (setq pos (1+ pos)))
  (setq p1 (substr str 1 (1- pos)))
  (setq p2 (substr str pos))
 (list p1 p2))
 ; Ŀ
 ;   Krak end.                                                             
 ; 

 ; Ŀ
 ;   Ati.                                                                  
 ; 
 (DEFUN C:ATI (/ ss leona incra incrp num tagnam entt pum)
  (command ".undo" "be")
  (prompt "Attdefs: ")
  (setq ss (ssget (list (cons 0 "ATTDEF"))))
 ; Ŀ
 ;   Ask whether to change the letter or number part of the tag.           
 ; 
  (initget 0 "Letter Number")
  (setq leona (getkword "Increment Letter/<Number>?:"))
  (if (null leona) (setq leona "Number"))
 ; Ŀ
 ;   See how many times to increment each attdef.                          
 ; 
  (setq incra 1)
  (if (setq incrp (getint "Increment steps (- = decrement) <1>?: "))
      (setq incra incrp))
 ; Ŀ
 ;   Adjust things if incra was negative.                                  
 ; 
  (if (minusp incra)
      (progn
           (setq pum ())
           (setq incra (abs incra)))
      (setq pum t))
 ; Ŀ
 ;   Change the selected attdefs.                                          
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq tagnam (cdr (setq asoc2 (assoc 2 entt))))
 ; Ŀ
 ;   Increment the tag.                                                    
 ; 
         (repeat incra (setq tagnam (incrox tagnam leona pum)))
         (setq entt (subst (cons 2 tagnam) asoc2 entt))
         (setq entt (subst (cons 3 tagnam) (assoc 3 entt) entt))
         (entmod entt)
         (princ))
  (command ".undo" "end")
 (princ))